//////////////////////////////////////////////
// MipDescriptor.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkImagesTests.MipDescriptor = class MipDescriptor extends nkDebug.TestClass
{
	static instance = new MipDescriptor ("nkImagesTests.MipDescriptor") ;

	// Utils
	getMipDescriptorConstructor (managed)
	{
		return managed ? nkImages.MipDescriptor : nkImages.unmanaged.MipDescriptor ;
	}

	// Common test methods
	// Constructor
	testDefaultConstructor (managed)
	{
		const ctor = MipDescriptor.instance.getMipDescriptorConstructor(managed) ;
		const d = new ctor () ;

		nkDebug.TestUtils.check(nk.isUnmanagedInstance(d) == !managed, "Managed state unexpected") ;
		nkDebug.TestUtils.areNumbersEqual(d._width, 0, 0, "Invalid width") ;
		nkDebug.TestUtils.areNumbersEqual(d._height, 0, 0, "Invalid height") ;
		nkDebug.TestUtils.areNumbersEqual(d._depth, 0, 0, "Invalid depth") ;
		nkDebug.TestUtils.areNumbersEqual(d._rowByteSize, 0, 0, "Invalid row byte size") ;
		nkDebug.TestUtils.areNumbersEqual(d._sliceByteSize, 0, 0, "Invalid slice byte size") ;
		nkDebug.TestUtils.areNumbersEqual(d._fullByteSize, 0, 0, "Invalid full byte size") ;

		if (!managed)
			d.delete() ;
	}

	testFullConstructor (managed)
	{
		const ctor = MipDescriptor.instance.getMipDescriptorConstructor(managed) ;
		const d = new ctor (10, 20, 5, 15, 300, 1500) ;

		nkDebug.TestUtils.check(nk.isUnmanagedInstance(d) == !managed, "Managed state unexpected") ;
		nkDebug.TestUtils.areNumbersEqual(d._width, 10, 0, "Invalid width") ;
		nkDebug.TestUtils.areNumbersEqual(d._height, 20, 0, "Invalid height") ;
		nkDebug.TestUtils.areNumbersEqual(d._depth, 5, 0, "Invalid depth") ;
		nkDebug.TestUtils.areNumbersEqual(d._rowByteSize, 15, 0, "Invalid row byte size") ;
		nkDebug.TestUtils.areNumbersEqual(d._sliceByteSize, 300, 0, "Invalid slice byte size") ;
		nkDebug.TestUtils.areNumbersEqual(d._fullByteSize, 1500, 0, "Invalid full byte size") ;

		if (!managed)
			d.delete() ;
	}

	testCopyConstructor (managed0, managed1)
	{
		const ctor0 = MipDescriptor.instance.getMipDescriptorConstructor(managed0) ;
		const ctor1 = MipDescriptor.instance.getMipDescriptorConstructor(managed1) ;
		const d0 = new ctor0 (10, 20, 5, 15, 300, 1500) ;
		const d1 = new ctor1 (d0) ;

		nkDebug.TestUtils.check(nk.isUnmanagedInstance(d0) == !managed0, "Managed state 0 unexpected") ;
		nkDebug.TestUtils.check(nk.isUnmanagedInstance(d1) == !managed1, "Managed state 1 unexpected") ;
		nkDebug.TestUtils.areNumbersEqual(d1._width, 10, 0, "Invalid width") ;
		nkDebug.TestUtils.areNumbersEqual(d1._height, 20, 0, "Invalid height") ;
		nkDebug.TestUtils.areNumbersEqual(d1._depth, 5, 0, "Invalid depth") ;
		nkDebug.TestUtils.areNumbersEqual(d1._rowByteSize, 15, 0, "Invalid row byte size") ;
		nkDebug.TestUtils.areNumbersEqual(d1._sliceByteSize, 300, 0, "Invalid slice byte size") ;
		nkDebug.TestUtils.areNumbersEqual(d1._fullByteSize, 1500, 0, "Invalid full byte size") ;

		if (!managed0)
			d0.delete() ;

		if (!managed1)
			d1.delete() ;
	}

	nkTests =
	{
		// Constructors
		DefaultConstructorUnmanaged : function () {MipDescriptor.instance.testDefaultConstructor(false) ;},
		DefaultConstructorManaged : function () {MipDescriptor.instance.testDefaultConstructor(true) ;},
		FullConstructorUnmanaged : function () {MipDescriptor.instance.testFullConstructor(false) ;},
		FullConstructorManaged : function () {MipDescriptor.instance.testFullConstructor(true) ;},
		CopyConstructorUnmanagedToUnmanaged : function () {MipDescriptor.instance.testCopyConstructor(false, false) ;},
		CopyConstructorUnmanagedToManaged : function () {MipDescriptor.instance.testCopyConstructor(false, true) ;},
		CopyConstructorManagedToUnmanaged : function () {MipDescriptor.instance.testCopyConstructor(true, false) ;},
		CopyConstructorManagedToManaged : function () {MipDescriptor.instance.testCopyConstructor(true, true) ;},
	}
}